unit sfolder;

interface

uses
  windows,registry;

type
    TSFolder = class
    private
          function GetWorkingDir :string;
          procedure ChangeWorkingDir(AWorkingDir :string);
    public
          MyDocumentsDir :string;
          WindowsDir :string;
          WindowsSystemDir :string;
          property WorkingDir :string read GetWorkingDir write ChangeWorkingDir;
          constructor Create; //W Delphi metody i funkcje musz by deklarowane po wasnociach
    end;


implementation

constructor TSFolder.Create;
var tmpdir :array[0..MAX_PATH] of char;
    Registry :TRegistry;
    Key :string;
begin

//WindowsDir
GetWindowsDirectory(tmpdir,MAX_PATH);
WindowsDir:=string(tmpdir);

//WindowsSystemDir
GetSystemDirectory(tmpdir,MAX_PATH);
WindowsSystemDir:=string(tmpdir);

//MyDocumentsDir
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
Key:='\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders';
if Registry.KeyExists(Key) then
    begin
    Registry.OpenKey(Key,false);
    if Registry.ValueExists('Personal') then
       begin
       MyDocumentsDir:=Registry.ReadString('Personal');
       end;
    end;
Registry.CloseKey;
Registry.Free;
end;

function TSFolder.GetWorkingDir;
var tmpdir :array[0..MAX_PATH] of char;
begin
GetCurrentDirectory(MAX_PATH,tmpdir);
GetWorkingDir:=string(tmpdir);
end;

procedure TSFolder.ChangeWorkingDir(AWorkingDir :string);
begin
SetCurrentDirectory(PChar(AWorkingDir));
end;

end.
